
# Create Card Response

Defines the fields that are included in the response body of
a request to the [CreateCard](/doc/apis/cards.md#create-card) endpoint.

Note: if there are errors processing the request, the card field will not be
present.

## Structure

`CreateCardResponse`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `errors` | [`?(Error[])`](/doc/models/error.md) | Optional | Information on errors encountered during the request. | getErrors(): ?array | setErrors(?array errors): void |
| `card` | [`?Card`](/doc/models/card.md) | Optional | Represents the payment details of a card to be used for payments. These<br>details are determined by the payment token generated by Web Payments SDK. | getCard(): ?Card | setCard(?Card card): void |

## Example (as JSON)

```json
{
  "card": {
    "billing_address": {
      "address_line_1": "500 Electric Ave",
      "address_line_2": "Suite 600",
      "administrative_district_level_1": "NY",
      "country": "US",
      "locality": "New York",
      "postal_code": "10003"
    },
    "bin": "411111",
    "card_brand": "VISA",
    "card_type": "CREDIT",
    "cardholder_name": "Amelia Earhart",
    "customer_id": "VDKXEEKPJN48QDG3BGGFAK05P8",
    "enabled": true,
    "exp_month": 11,
    "exp_year": 2022,
    "fingerprint": "ex-p-cs80EK9Flz7LsCMv-szbptQ_ssAGrhemzSTsPFgt9nzyE6t7okiLIQc-qw_quqKX4Q",
    "id": "ccof:uIbfJXhXETSP197M3GB",
    "last_4": "1111",
    "merchant_id": "6SSW7HV8K2ST5",
    "prepaid_type": "NOT_PREPAID",
    "reference_id": "user-id-1",
    "version": 1
  }
}
```

